<?php
// Verifica se existe um título definido na página, se não, usa o padrão
$pageTitle = isset($page_title) ? $page_title . ' - ' . $siteConfig['server_name'] : $siteConfig['server_name'];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo $siteConfig['meta_description']; ?>">
    
    <title><?php echo $pageTitle; ?></title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <meta property="og:title" content="<?php echo $pageTitle; ?>">
    <meta property="og:description" content="<?php echo $siteConfig['meta_description']; ?>">
    <meta property="og:type" content="website">

    <style>
        body { background-color: #f4f6f9; min-height: 100vh; display: flex; flex-direction: column; }
        
        /* CORES DINÂMICAS DO BANCO DE DADOS */
        .navbar-custom { 
            background-color: <?php echo $siteConfig['color_header']; ?> !important; 
        }
        
        .footer-custom {
            background-color: <?php echo $siteConfig['color_footer']; ?> !important;
            color: white;
        }

        .hero-section {
            background: linear-gradient(135deg, <?php echo $siteConfig['color_hero_start']; ?> 0%, <?php echo $siteConfig['color_hero_end']; ?> 100%);
            color: white;
            padding: 60px 0;
            border-bottom-left-radius: 50px;
            border-bottom-right-radius: 50px;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }

        /* Estilos Gerais */
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            transition: transform 0.3s;
        }
        .card-custom:hover { transform: translateY(-5px); }
        
        .btn-download {
            background-color: #ffcb05;
            color: #3b4cca;
            font-weight: bold;
            border: none;
            padding: 15px 30px;
            font-size: 1.2rem;
            transition: all 0.3s;
        }
        .btn-download:hover { background-color: #e6b800; transform: scale(1.05); }
        
        /* Garante que o footer fique lá embaixo mesmo com pouco conteudo */
        .content-wrapper { flex: 1; }
    </style>
</head>
<body>

    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom sticky-top">
        <div class="container">
            <a class="navbar-brand fw-bold" href="index.php">
                <i class="fas fa-gamepad"></i> <?php echo $siteConfig['server_name']; ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="index.php">Início</a></li>
                    <li class="nav-item"><a class="nav-link" href="highscores.php">Rank</a></li>
                    <li class="nav-item"><a class="nav-link" href="guilds.php">Guilds</a></li>
                    <li class="nav-item"><a class="nav-link" href="shop.php">Shop</a></li>
                    <li class="nav-item ms-2">
                        <a href="register.php" class="btn btn-outline-light btn-sm mt-1">Criar Conta</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <div class="content-wrapper">